const express = require("express");
const { verify, logout } = require("../../controllers/admin/auth");
const users = require("../../controllers/admin/user");
const subscriptionPlan = require("../../controllers/admin/subscriptionPlan");

const AuthorizeRoutes = express.Router();

AuthorizeRoutes.route("/verify").get(verify);
AuthorizeRoutes.route("/logout").post(logout);

AuthorizeRoutes.route("/users").post(users.list);
AuthorizeRoutes.route("/users/:id").get(users.view);
AuthorizeRoutes.route("/users/:id").put(users.update);

//Subscription Plan Routes
AuthorizeRoutes.route("/subscription-plans").post(subscriptionPlan.list);
AuthorizeRoutes.route("/subscription-plan").post(subscriptionPlan.save);
AuthorizeRoutes.route("/subscription-plan/:id").put(subscriptionPlan.update);
AuthorizeRoutes.route("/subscription-plan/:id").delete(subscriptionPlan.delete);
AuthorizeRoutes.route("/subscription-plan/:id").get(subscriptionPlan.view);
AuthorizeRoutes.route("/subscription-plan/:id/status").put(subscriptionPlan.status);

module.exports = AuthorizeRoutes;
