const express = require("express");
const { profileInfo } = require("../../controllers/frontend/profile");
const {
  isUserRegistered,
} = require("../../middleware/frontend");
const user = require("../../controllers/frontend/user");
const logs = require("../../controllers/frontend/logs");
const subscription = require("../../controllers/frontend/subscription");
const attendance = require("../../controllers/frontend/attendance");

const AuthorizeRoutes = express.Router();
AuthorizeRoutes.route("/profile").get(isUserRegistered, profileInfo);

AuthorizeRoutes.route("/user-info").get(isUserRegistered, user.userInfo);
AuthorizeRoutes.route("/save-user-settings").post(
  isUserRegistered,
  user.userSettings
);

AuthorizeRoutes.route("/logs").get(isUserRegistered, logs.walletLogs);
AuthorizeRoutes.route("/order-logs").get(isUserRegistered, logs.purchaseLogs);
AuthorizeRoutes.route("/reward-logs").get(isUserRegistered, logs.rewardLogs);

// Subscription Routes
AuthorizeRoutes.route("/create-subscription-payment").post(
  isUserRegistered,
  subscription.createPaymentIntent
);

AuthorizeRoutes.route("/create-subscription").post(
  isUserRegistered,
  subscription.createSubscription
);

AuthorizeRoutes.route("/check-active-subscription").get(
  isUserRegistered,
  subscription.checkActiveSubscription
);

AuthorizeRoutes.route("/cancel-subscription").post(
  isUserRegistered,
  subscription.cancelSubscription
);

AuthorizeRoutes.route("/reactivate-subscription").post(
  isUserRegistered,
  subscription.reactivateSubscription
);

AuthorizeRoutes.route("/change-subscription-plan").post(
  isUserRegistered,
  subscription.changePlan
);

AuthorizeRoutes.route("/subscription-history").get(
  isUserRegistered,
  subscription.getSubscriptionHistory
);

module.exports = AuthorizeRoutes;
