const express = require("express");
const { login, userRegistration, verifyEmail, forgotPassword, resetPassword, logout } = require("../../controllers/frontend/auth");
const { home } = require("../../controllers/frontend/home");
const subscription = require("../../controllers/frontend/subscription");
const healthCheck = require("../../controllers/frontend/health");
const GuestRoutes = express.Router();

// Health check endpoint - no authentication required
GuestRoutes.route("/health").get(healthCheck);

GuestRoutes.route("/login").post(login);
GuestRoutes.route("/logout").post(logout);
GuestRoutes.route("/register").post(userRegistration);
GuestRoutes.route("/verify-email").get(verifyEmail).post(verifyEmail);
GuestRoutes.route("/forgot-password").post(forgotPassword);
GuestRoutes.route("/reset-password").get(resetPassword).post(resetPassword);

GuestRoutes.route("/home").get(home);

//Subscription Plans Routes
GuestRoutes.route("/subscription-plans").get(subscription.getActivePlans);
GuestRoutes.route("/subscription-plans/:id").get(subscription.getPlanById);

// Stripe Webhook Route (must use raw body - handled in app.js)
GuestRoutes.route("/stripe-webhook").post(subscription.stripeWebhook);

module.exports = GuestRoutes;
