const validate = (schema) => (req, res, next) => {
    try {
        schema.parse({
            body: req.body,
            query: req.query,
            params: req.params,
        });
        next();
    } catch (err) {
        return res.status(400).send(err.errors);
        //return next(new AppError(err, 404));
    }
};

module.exports = validate;
